<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdminController;

// ---------------- User Routes ----------------
Route::get('/register', [AuthController::class, 'showUserRegisterForm'])->name('user.register');
Route::post('/register', [AuthController::class, 'userRegister'])->name('user.register.submit');

Route::get('/login', [AuthController::class, 'showUserLoginForm'])->name('login'); // must be 'login'
Route::post('/login', [AuthController::class, 'userLogin'])->name('login.submit');

Route::middleware('auth')->group(function () {
    Route::get('/user/dashboard', [AuthController::class, 'userDashboard'])->name('user.dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

// ---------------- Admin Routes ----------------
Route::get('/admin/login', [AdminController::class, 'showAdminLoginForm'])->name('admin.login');
Route::post('/admin/login', [AdminController::class, 'adminLogin'])->name('admin.login.submit');

Route::middleware('auth:admin')->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'adminDashboard'])->name('admin.dashboard');
    Route::post('/admin/logout', [AdminController::class, 'adminLogout'])->name('admin.logout');
});
