<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Register</title>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    
    <!-- SweetAlert2 for alerts -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to right, #74ebd5, #ACB6E5);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .register-card {
            background: #fff;
            padding: 40px 30px;
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
        }

        .register-card h2 {
            text-align: center;
            margin-bottom: 25px;
            color: #333;
        }

        .register-card input {
            width: 100%;
            padding: 12px 15px;
            margin: 10px 0;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 16px;
            transition: 0.3s;
        }

        .register-card input:focus {
            border-color: #007BFF;
            outline: none;
            box-shadow: 0 0 5px rgba(0,123,255,0.5);
        }

        .register-card button {
            width: 100%;
            padding: 12px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 15px;
            transition: 0.3s;
        }

        .register-card button:hover {
            background-color: #0056b3;
        }

        .register-card p {
            text-align: center;
            margin-top: 15px;
        }

        .register-card a {
            color: #007BFF;
            text-decoration: none;
            font-weight: 500;
        }

        .register-card a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="register-card">
        <h2>User Registration</h2>

        <form method="POST" action="<?php echo e(route('user.register.submit')); ?>">
            <?php echo csrf_field(); ?>
            <input type="text" name="name" placeholder="Name" required>
            <input type="email" name="email" placeholder="Email" required>
            <input type="password" name="password" placeholder="Password" required>
            <input type="password" name="password_confirmation" placeholder="Confirm Password" required>
            <button type="submit">Register</button>
        </form>

        <p>Already have an account? <a href="<?php echo e(route('login')); ?>">Login here</a></p>
    </div>

    <!-- SweetAlert2 Success/Error Alerts -->
    <?php if(session('success')): ?>
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: '<?php echo e(session('success')); ?>',
            timer: 2000,
            showConfirmButton: false
        });
    </script>
    <?php endif; ?>

    <?php if($errors->any()): ?>
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: '<?php echo e($errors->first()); ?>',
        });
    </script>
    <?php endif; ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Laravel Projects\register-login\resources\views/auth/user-register.blade.php ENDPATH**/ ?>